#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "mtim8_timer.h"
#include "mtim16_timer.h"
#include "initial_setting.h"

#define LED1 PTAD_PTAD3     //GPIO PTA3 is configured as LED D6
#define LED2 PTAD_PTAD4     //GPIO PTA2 is configured as LED D8

void sample_mtim_callback(unsigned char MTIM_Index)      //function to be called in case of interrupt
{
  switch(MTIM_Index) 
  {
    case MTIM_1:
      break;
    
    case MTIM_2:
      LED1 = ~LED1;                   //LED D6 toggles after the delay set in MTIM2
      break;
               
    case MTIM_3:
      LED2= ~LED2;                   //LED D8 toggles after the delay set in MTIM23
      break;
  }
  return;
}

void main(void) {

  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  InitConfig();      //initializes the clock
  
  
  SCGC3_PTA = 1;       //enables the clock for port C
    
  PTADD_PTADD3 = 1; //makes the GPIO pin PTA3 as output
  PTADD_PTADD4 = 1; //makes the GPIO pin PTA4 as output
          
  MTIM2_Init(&(sample_mtim_callback));
  LED1 = 1;        //LED D6 Glows immediately after reset 
  Set_TimeOut_MTIM2(2000);
  
  
  MTIM3_Init(&(sample_mtim_callback));
  LED2= 1;         //LED D7 Glows
  Enable_MTIM3(1000);
   
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}
